<?php
// FIXED: Removed leading tab before PHP opening tag - 2025-01-21 by Shahnur Alam
if ( ! defined( 'ABSPATH' ) ) {
	die;
}
	$ttbm_post_id = $ttbm_post_id ?? get_the_id();
	$tour_id=$tour_id??TTBM_Function::post_id_multi_language($ttbm_post_id);
	$tour_date  = $tour_date ?? TTBM_Function::get_date( $tour_id )[0];
	$hotel_id   = $hotel_id ?? current( TTBM_Function::get_hotel_list( $tour_id ) );
//	$room_lists = TTBM_Global_Function::get_post_info( $hotel_id, 'ttbm_room_details', array() );
	$date_range ='';
	if (isset($_POST['nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nonce'])), 'ttbm_frontend_nonce')) {
		$date_range = isset( $_REQUEST['date_range'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['date_range'] ) ) : '';
	}
//    $hotel_booking_data = TTBM_Global_Function::get_hotel_bookings($hotel_id, $check_in, $check_out);
    $hotel_date = explode( "-", $date_range );
    $date1      = gmdate( 'Y-m-d', strtotime( $hotel_date[0] ) );
    $date2      = gmdate( 'Y-m-d', strtotime( $hotel_date[1] ) );
    $days       = date_diff( date_create( $date1 ), date_create( $date2 ) );
    $room_lists = TTBM_Global_Function::ttbm_get_full_room_ticket_info( $hotel_id, $date1, $date2 );

	if ( sizeof( $room_lists ) > 0 && $hotel_id && $date_range ) {

		?>
		<input type="hidden" name='ttbm_tour_hotel_list' value='<?php echo esc_attr( $hotel_id ); ?>'>
		<input type="hidden" name='ttbm_hotel_num_of_day' value='<?php echo esc_attr( $days->days ); ?>'>
		<input type="hidden" name='ttbm_checkin_date' value='<?php echo esc_attr( $date1 ); ?>'>
		<input type="hidden" name='ttbm_checkout_date' value='<?php echo esc_attr( $date2 ); ?>'>
		<div class="ttbm_default_widget mT">
			<?php
				$option_name   = 'ttbm_string_availabe_ticket_list';
				$default_title = esc_html__( 'Available Room List ', 'tour-booking-manager' );
				include( TTBM_Function::template_path( 'layout/title_section.php' ) );
			?>
			<div class="ttbm_widget_content" data-placeholder>
				<table class="mp_tour_ticket_type">
					<thead>
					<tr>
						<th><?php echo esc_html( TTBM_Function::ticket_name_text() ); ?></th>
						<th><?php echo esc_html( TTBM_Function::ticket_price_text() ); ?></th>
						<th><?php echo esc_html( TTBM_Function::ticket_qty_text() ); ?></th>
					</tr>
					</thead>
					<tbody>
					<?php
						foreach ( $room_lists as $ticket ) {
							$room_name        = array_key_exists( 'ttbm_hotel_room_name', $ticket ) ? $ticket['ttbm_hotel_room_name'] : '';
							$price            = array_key_exists( 'ttbm_hotel_room_price', $ticket ) ? $ticket['ttbm_hotel_room_price'] : 0;
							$sale_price       = array_key_exists( 'sale_price', $ticket ) ? $ticket['sale_price'] : '';
							$price            = TTBM_Global_Function::wc_price( $tour_id, $price );
							$ticket_price_raw = TTBM_Global_Function::price_convert_raw( $price );
							$ticket_qty       = array_key_exists( 'ttbm_hotel_room_qty', $ticket ) ? $ticket['ttbm_hotel_room_qty'] : 0;
							$reserve          = 0;
							$min_qty          = apply_filters( 'ttbm_ticket_type_min_qty', 0 );
							$max_qty          = apply_filters( 'ttbm_ticket_type_max_qty', 0 );
							$sold_type        = TTBM_Function::get_total_sold( $tour_id, $tour_date, $room_name, $hotel_id );
//							$available        = $ticket_qty - ( $sold_type + $reserve );
							$available        = $ticket['available'] + $reserve;

							?>
							<tr>
								<td>
									<h5><?php echo esc_html( $room_name ); ?></h5>
									<?php
										$adult_qty = array_key_exists( 'ttbm_hotel_room_capacity_adult', $ticket ) ? $ticket['ttbm_hotel_room_capacity_adult'] : 0;
										$child_qty = array_key_exists( 'ttbm_hotel_room_capacity_child', $ticket ) ? $ticket['ttbm_hotel_room_capacity_child'] : 0;
									?>
                                    <span class="badge-gray"><i class="fas fa-user-alt"></i><?php echo esc_html( $adult_qty ); ?></span>
                                    <?php if( $child_qty > 0 ){?>
                                        <span class="badge-gray"><i class="fas fa-child-dress"></i> <?php echo esc_html( $child_qty ); ?></span>
                                    <?php }?>
                                    <?php if( $available > 0 ) { ?>
                                        <span class="badge-gray"><i class="fas fa-circle" style="color:green;"></i> <?php echo esc_attr( $available );?></span>
                                    <?php }?>
								</td>
								<td>
									<?php if ($sale_price) { ?>
                                        <span class="strikeLine"><?php 
										// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped  
										echo wc_price($tour_id, $sale_price); ?></span>
									<?php } ?>
									<?php echo wp_kses_post( $price ); ?>/
									<?php esc_html_e( 'Night ', 'tour-booking-manager' ); ?>&nbsp;X
									<?php echo esc_html( $days->days ); ?>
								</td>
								<td><?php TTBM_Layout::qty_input( $room_name, $available, 'inputbox', 0, $min_qty, $max_qty, $ticket_price_raw, 'ticket_qty[]' ); ?></td>
							</tr>
							<tr>
								<td colspan=3>
									<input type="hidden" name='tour_id[]' value='<?php echo esc_html( $tour_id ); ?>'>
									<input type="hidden" name='ticket_name[]' value='<?php echo esc_html( $room_name ); ?>'>
									<input type="hidden" name='ticket_max_qty[]' value='<?php echo esc_html( $max_qty ); ?>'>
									<?php do_action( 'ttbm_after_ticket_type_item', $tour_id, $ticket ); ?>
								</td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
		<?php
		include( TTBM_Function::template_path( 'ticket/extra_service.php' ) );
		do_action( 'ttbm_book_now_before', $tour_id );
		include( TTBM_Function::template_path( 'ticket/book_now.php' ) );
	} else {
		?>
		<div class="dLayout allCenter _mT_bgWarning" data-placeholder>
			<h3 class="textWhite"><?php esc_html_e( 'No Room available !', 'tour-booking-manager' ); ?></h3>
		</div>
		<?php
	}
?>