<?php

namespace Elementor;

class goto_widget_blog extends Widget_Base {

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_name() {
        return 'blog';
    }

    public function get_title() {
        return esc_html__( 'Blog Posts', 'goto' );
    }

    public function get_icon() {
        return 'eicon-post';
    }

    protected function register_controls() {
        $this->sectionGeneral();
        $this->sectionQuery();
        $this->sectionPagination();
    }

    private function sectionGeneral(){
        $this->start_controls_section(
            'section_content',
            [
                'label' =>  esc_html__( 'General', 'goto' ),
            ]
        );

        $this->add_control( 'b_layout', array(
            'type'    => Controls_Manager::SELECT,
            'label'   => esc_html__( 'Layout', 'goto' ),
            'default' => 'grid',
            'options' => array(
                'grid' => esc_html__( 'Grid', 'goto' ),
                'list' => esc_html__( 'List', 'goto' )
            ),
        ));

        $this->add_responsive_control( 'columns', array(
            'type'           => Controls_Manager::SELECT,
            'label'          => esc_html__( 'Columns', 'goto' ),
            'default'        => 3,
            'tablet_default' => 2,
            'mobile_default' => 1,
            'options'        => array(
                1 => 1,
                2 => 2,
                3 => 3,
                4 => 4,
                5 => 5,
            ),
            'condition' => array(
                'b_layout' => 'grid',
            ),
        ));

        $this->add_control( 'words', array(
            'type'      => Controls_Manager::NUMBER,
            'label'     => esc_html__( 'Post excerpt limit', 'goto' ),
            'default'   => 140,
            'min'       => 10,
            'max'       => 300,
            'step'      => 1,
            'condition' => array(
                'b_layout' => 'list',
            ),
        ));

        $this->add_control( 'pagi', array(
            'type'         => Controls_Manager::SWITCHER,
            'label'        => esc_html__( 'Pagination', 'goto' ),
            'default'      => '',
            'label_on'     => esc_html__( 'Yes', 'goto' ),
            'label_off'    => esc_html__( 'No', 'goto' ),
            'return_value' => 'yes',
        ));

        $this->end_controls_section();
    }

    private function sectionQuery(){
        $this->start_controls_section( 'b_query', array(
            'label' => esc_html__( 'Query', 'goto' ),
        ));

        $this->add_control(
            'widget_select_cat_blog',
            [
                'label'     =>  esc_html__( 'Categories', 'goto' ),
                'type'      =>  Controls_Manager::SELECT2,
                'options'   =>  goto_get_narrow_data( 'blog_cat' ),
                'multiple'  =>  true,
            ]
        );

        $this->add_control(
            'widget_limit_post',
            [
                'label'     =>  esc_html__( 'Posts Per Page', 'goto' ),
                'type'      =>  Controls_Manager::NUMBER,
                'default'   =>  6,
                'min'       =>  1,
                'max'       =>  100,
                'step'      =>  1,
            ]
        );

        $this->add_control(
            'widget_order_by',
            [
                'label'     =>  esc_html__( 'Order By', 'goto' ),
                'type'      =>  Controls_Manager::SELECT,
                'default'   =>  'id',
                'options'   =>  [
                    'id'    =>  esc_html__( 'ID', 'goto' ),
                    'name'  =>  esc_html__( 'Name', 'goto' ),
                    'date'  =>  esc_html__( 'Date', 'goto' ),
                ],
            ]
        );

        $this->add_control(
            'widget_order',
            [
                'label'     =>  esc_html__( 'Order', 'goto' ),
                'type'      =>  Controls_Manager::SELECT,
                'default'   =>  'ASC',
                'options'   =>  [
                    'ASC'   =>  esc_html__( 'ASC', 'goto' ),
                    'DESC'  =>  esc_html__( 'DESC', 'goto' ),
                ],
            ]
        );

        $this->end_controls_section();
    }

    private function sectionPagination(){
        $this->start_controls_section( 'b_pagi', array(
            'label'     => esc_html__( 'Pagination', 'goto' ),
            'condition' => array(
                'pagi' => 'yes',
            ),
        ));

        $this->add_responsive_control( 'pagi_position', array(
            'type'    => Controls_Manager::CHOOSE,
            'label'   => esc_html__( 'Alignment', 'goto' ),
            'options' => array(
                'left' => array(
                    'title' => esc_html__( 'Left', 'goto' ),
                    'icon'  => 'fa fa-align-left'
                ),
                'center' => array(
                    'title' => esc_html__( 'Center', 'goto' ),
                    'icon'  => 'fa fa-align-center'
                ),
                'right' => array(
                    'title' => esc_html__( 'Right', 'goto' ),
                    'icon'  => 'fa fa-align-right'
                ),
            ),
            'default'        => 'center',
            'tablet_default' => 'center',
            'mobile_default' => 'center',
            'selectors'      => array(
                '{{WRAPPER}} .ht-pagination' => 'text-align: {{VALUE}};'
            ),
        ));

        $this->add_responsive_control( 'pagi_space', array(
            'type'       => Controls_Manager::DIMENSIONS,
            'label'      => esc_html__( 'Space', 'goto' ),
            'size_units' => array( 'px', 'em' ),
            'default'    => array(
                'top'      => '30',
                'right'    => '0',
                'bottom'   => '0',
                'left'     => '0',
                'unit'     => 'px',
                'isLinked' => false,
            ),
            'tablet_default' => array(
                'top'      => '20',
                'right'    => '0',
                'bottom'   => '20',
                'left'     => '0',
                'unit'     => 'px',
                'isLinked' => false,
            ),
            'mobile_default' => array(
                'top'      => '15',
                'right'    => '0',
                'bottom'   => '15',
                'left'     => '0',
                'unit'     => 'px',
                'isLinked' => false,
            ),
            'selectors' => array(
                '{{WRAPPER}} .ht-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
            ),
        ));

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $cat_id = $settings['widget_select_cat_blog'];

        $columns = isset( $settings['columns']) ? $settings['columns'] : 3;
        $tablet_columns = isset( $settings['columns_tablet']) ? $settings['columns_tablet'] : 2;
        $mobile_columns = isset( $settings['columns_mobile']) ? $settings['columns_mobile'] : 1;

        $classes = 'grid' == $settings['b_layout'] ? 'wd-blog ht-grid ht-grid-'.  $columns .' ht-grid-tablet-'. $tablet_columns .' ht-grid-mobile-'. $mobile_columns : 'wd-blog wd-blog-list';
        $paged = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;

        $args = array(
            'post_type'      => 'post',
            'post_status'    => 'publish',
            'posts_per_page' => $settings['widget_limit_post'],
            'orderby'        => $settings['widget_order_by'],
            'order'          => $settings['widget_order'],
            'paged'          => $paged,
        );

        if ( ! empty( $cat_id ) ) :
            $args['cat'] = $cat_id;
        endif;

        $post_query = new \WP_Query( $args );
        ?>
            <div class="<?php echo esc_attr( $classes ); ?>">
                <?php
                    while ( $post_query -> have_posts() ) :
                        $post_query -> the_post();

                        $format = get_post_format( get_the_ID() );
                        $cls = 'ion-image';
                        switch( $format ){
                            case 'audio':
                            case 'video':
                                $cls = 'ion-play';
                                break;
                            case 'gallery':
                                $cls = 'ion-images';
                                break;
                        }

                        $img_id = get_post_thumbnail_id( get_the_ID() );
                        $img_alt = goto_img_alt( $img_id, esc_attr__( 'Blog thumbnail image', 'goto' ) );
                        $img_src = ! empty( $img_id ) ? get_the_post_thumbnail_url( get_the_ID(), 'medium_large' ) : get_template_directory_uri() . '/images/tour/370x240.png';
                    ?>
                    <div class="element-blog__item<?php echo ( 'grid' == $settings['b_layout'] ? ' ht-grid-item' : '' ); ?>" <?php goto_schema_markup( 'article' ); ?>>
                        <article itemprop="mainEntityOfPage">
                            <a href="<?php the_permalink(); ?>" class="element-blog__item--img">
                                <img src="<?php echo esc_url( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>" itemprop="image">

                                <?php if( is_sticky() ): ?>
                                    <span class="wdp-sticky sticky-medal">
                                        <span><?php esc_html_e( 'Sticky', 'goto' ); ?></span>
                                    </span>
                                <?php endif; ?>

                                <?php if( 'list' == $settings['b_layout'] ): ?>
                                    <span class="bl-date"><?php echo get_the_date(); ?></span>
                                <?php endif; ?>
                            </a>

                            <time class="sr-only" itemprop="datePublished" datetime="<?php echo get_the_time( 'c' ); ?>"><?php echo get_the_date(); ?></time>

                            <div class="element-blog__item--content">
                                <?php if( 'grid' == $settings['b_layout'] ): ?>
                                    <span class="element-blog__item--cat">
                                        <span class="element-blog__item--format <?php echo esc_attr( $cls ); ?>"></span>
                                        <span class="element-blog__item--cat-item"><?php the_category( ', ' ); ?></span>
                                    </span>
                                <?php endif; ?>

                                <h3 class="element-blog__item--title" itemprop="headline">
                                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                </h3>

                                <div class="element-blog__item--meta">
                                    <?php if( 'grid' == $settings['b_layout'] ): ?>
                                        <div class="element-blog__item--meta-item">
                                            <span class="goto-icon-calendar"></span>
                                            <span class="element-blog__item--date">
                                                <?php echo get_the_date(); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                    <div class="element-blog__item--meta-item">
                                        <span class="goto-icon-user"></span>
                                        <span class="element-blog__item--author" itemprop="author">
                                            <?php echo esc_html__( 'By', 'goto' ) . ' ' . get_the_author(); ?>
                                        </span>
                                    </div>

                                    <?php if( 'list' == $settings['b_layout'] ): ?>
                                        <div class="element-blog__item--meta-item">
                                            <span class="fa fa-bookmark-o"></span>
                                            <span class="element-blog__item--cat">
                                                <?php the_category( ', ' ); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                    <?php /*structured-data*/ ?>
                                    <div class="sr-only">
                                        <?php /*publisher*/ ?>
                                        <span class="author" <?php goto_schema_markup( 'publisher' ); ?>>
                                            <span itemprop="logo" itemscope="itemscope" itemtype="https://schema.org/ImageObject" >
                                                <meta itemprop="url" content="<?php echo esc_url( home_url( '/' ) ); ?>" />
                                                <meta itemprop="width" content="100" />
                                                <meta itemprop="height" content="100" />
                                            </span>
                                            <meta itemprop="name" content="<?php the_author(); ?>" />
                                        </span>

                                        <?php /*date modified*/ ?>
                                        <span itemprop="dateModified" class="updated">
                                            <time datetime="<?php echo esc_attr( get_the_modified_time( 'Y-m-d' ) ); ?>">
                                                <?php the_modified_date(); ?>
                                            </time>
                                        </span>
                                    </div>
                                </div>

                                <?php if( 'list' == $settings['b_layout'] ): ?>
                                    <div class="bl-summary" itemprop="text">
                                        <?php goto_limit_excerpt( $settings['words'] ); ?>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="bl-read-more"><?php esc_html_e( 'Read More +', 'goto' ); ?></a>
                                <?php else: ?>
                                    <div class="sr-only" itemprop="text">
                                        <?php goto_limit_excerpt( 140 ); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </article>
                    </div>
                <?php
                    endwhile;

                    if( 'yes' == $settings['pagi'] )
                        goto_paging( $post_query );

                    wp_reset_postdata();
                ?>
            </div>
    <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new goto_widget_blog() );