<?php

namespace Elementor;

abstract class Goto_Carousel_Base extends Widget_Base {
    public function get_script_depends() {
        return array( 'tiny-slider-js' );
    }

    protected function sectionArrows(){
        $this->start_controls_section( 'd_arrows', array(
            'label'     => esc_html__( 'Arrows', 'goto' ),
            'condition' => array(
                'd_layout.layout' => 'carousel',
                'd_layout.arrows' => 'yes',
            ),
        ));

        $this->add_control( 'arrows_size', array(
            'type'    => Controls_Manager::SLIDER,
            'label'   => esc_html__( 'Size', 'goto' ),
            'default' => array(
                'size' => 50
            ),
            'range' => array(
                'px' => array(
                    'min'  => 1,
                    'max'  => 200,
                    'step' => 1
                ),
            ),
            'size_units' => array( 'px' ),
            'selectors'  => array(
                '{{WRAPPER}} .tns-controls [data-controls]' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
            ),
        ));

        $this->add_control( 'arrows_position', array(
            'type'    => Controls_Manager::SLIDER,
            'label'   => esc_html__( 'Horizontal Pisition', 'goto' ),
            'default' => array(
                'size' => -70
            ),
            'range' => array(
                'px' => array(
                    'min'  => -200,
                    'max'  => 200,
                    'step' => 1
                ),
            ),
            'size_units' => array( 'px' ),
            'selectors'  => array(
                '{{WRAPPER}} .tns-controls [data-controls="next"]' => 'right: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .tns-controls [data-controls="prev"]' => 'left: {{SIZE}}{{UNIT}};',
            ),
        ));

        $this->add_control( 'arrows_color', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Color', 'goto' ),
            'default'   => '#fff',
            'selectors' => array(
                '{{WRAPPER}} .tns-controls [data-controls]' => 'color: {{VALUE}};'
            ),
        ));

        $this->add_control( 'arrows_bg', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Background color', 'goto' ),
            'default'   => '#aaa',
            'selectors' => array(
                '{{WRAPPER}} .tns-controls [data-controls]' => 'background-color: {{VALUE}};'
            ),
        ));

        $this->add_control( 'arrows_tablet', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Hide on Tablet', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel',
			)
		));

		$this->add_control( 'arrows_mobile', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Hide on Mobile', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

        $this->end_controls_section();
    }

    protected function sectionDots(){
        $this->start_controls_section( 'd_dots', array(
            'label'     => esc_html__( 'Dots', 'goto' ),
            'condition' => array(
                'd_layout.layout' => 'carousel',
                'd_layout.dots'   => 'yes',
            ),
        ));

        $this->add_responsive_control( 'd_align', array(
            'type'    => Controls_Manager::CHOOSE,
            'label'   => esc_html__( 'Alignment', 'goto' ),
            'options' => array(
                'left' => array(
                    'title' => esc_html__( 'Left', 'goto' ),
                    'icon'  => 'fa fa-align-left'
                ),
                'center' => array(
                    'title' => esc_html__( 'Center', 'goto' ),
                    'icon'  => 'fa fa-align-center'
                ),
                'right' => array(
                    'title' => esc_html__( 'Right', 'goto' ),
                    'icon'  => 'fa fa-align-right'
                ),
            ),
            'default'        => 'center',
            'tablet_default' => 'center',
            'mobile_default' => 'center',
            'selectors'      => array(
                '{{WRAPPER}} .tns-nav' => 'text-align: {{VALUE}};'
            ),
        ));

        $this->add_control( 'dots_bg', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Background color', 'goto' ),
            'default'   => 'rgba( 255, 255, 255, 0.3 )',
            'selectors' => array(
                '{{WRAPPER}} .tns-nav button' => 'background-color: {{VALUE}};'
            ),
        ));

        $this->add_control( 'dots_active_bg', array(
            'type'      => Controls_Manager::COLOR,
            'label'     => esc_html__( 'Current background color', 'goto' ),
            'default'   => '#eeeeee',
            'selectors' => array(
                '{{WRAPPER}} .tns-nav button.tns-nav-active' => 'background-color: {{VALUE}};'
            ),
        ));

        $this->add_control( 'dots_tablet', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Hide on Tablet', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel',
			)
		));

		$this->add_control( 'dots_mobile', array(
			'type'         => Controls_Manager::SWITCHER,
			'label'        => esc_html__( 'Hide on Mobile', 'goto' ),
			'default'      => 'yes',
			'label_on'     => esc_html__( 'Yes', 'goto' ),
			'label_off'    => esc_html__( 'No', 'goto' ),
			'return_value' => 'yes',
			'condition'    => array(
				'layout' => 'carousel'
			)
		));

        $this->end_controls_section();
    }

    /*RENDER CAROUSEL FOR FRONT-END VIEW*/
    protected function renderCarousel( $tiny_slider_id, $layout, $col_desktop, $col_tablet, $col_mobile ){
        $settings = $this->get_settings_for_display();

        if( 'carousel' != $layout ) return;

        /*ENQUEUE SCRIPT AND STYLE*/
        wp_enqueue_style( 'tiny-slider' );
        wp_enqueue_script( 'tiny-slider-js' );

        /*GET TINY SLIDER OPTIONS*/
		$arrows        = 'yes' == $settings['arrows'] ? 1 : 0;
		$arrows_tablet = 'yes' == $settings['arrows'] && 'yes' == $settings['arrows_tablet'] ? 0 : 1;
		$arrows_mobile = 'yes' == $settings['arrows'] && 'yes' == $settings['arrows_mobile'] ? 0 : 1;
		$dots          = 'yes' == $settings['dots'] ? 1 : 0;
		$dots_tablet   = 'yes' == $settings['dots'] && 'yes' == $settings['dots_tablet'] ? 0 : 1;
		$dots_mobile   = 'yes' == $settings['dots'] && 'yes' == $settings['dots_mobile'] ? 0 : 1;

        // Col.
        $desktop_col = $col_desktop ? $col_desktop : 2;
        $tablet_col  = $col_tablet ? $col_tablet : $desktop_col;
        $mobile_col  = $col_mobile ? $col_mobile : $desktop_col;

        wp_add_inline_script(
            'tiny-slider-js',
            "document.addEventListener( 'DOMContentLoaded', function(){
                var _arr        = 1 == {$arrows} ? true : false,
					_arr_tablet = _arr && 1 == {$arrows_tablet} ? true : false,
					_arr_mobile = _arr && 1 == {$arrows_mobile} ? true : false,
					_dot        = 1 == {$dots} ? true : false,
					_dot_tablet = _dot && 1 == {$dots_tablet} ? true : false,
					_dot_mobile = _dot && 1 == {$dots_mobile} ? true : false;

                var slider = tns({
                    container: '#{$tiny_slider_id}',
                    controls: _arr_mobile,
                    nav: _dot_mobile,
                    items: {$mobile_col},
                    autoHeight: true,
                    mouseDrag: true,
                    loop: false,
                    responsive: {
                        768: {
                            items: {$tablet_col},
                            controls: _arr_tablet,
                            nav: _dot_tablet,
                        },
                        1024: {
                            items: {$desktop_col},
                            controls: _arr,
                            nav: _dot,
                        }
                    }
                });
            } );",
            'after'
        );
    }

    /*RENDER CAROUSEL FOR PREVIEW MODE*/
    protected function carouselOptions( $layout, $col_desktop, $col_tablet, $col_mobile ){
        $settings = $this->get_settings_for_display();

        if( 'carousel' != $layout ) return '';

        $options = array(
            "items"      => intval( $col_mobile ),
            "controls"   => 'yes' == $settings['arrows'] && 'yes' != $settings['arrows_mobile'] ? true : false,
            "nav"        => 'yes' == $settings['dots'] && 'yes' != $settings['dots_mobile'] ? true : false,
            "loop"       => false,
            "autoHeight" => true,
            "responsive" => array(
				768  => array(
					"items"    => intval( $col_tablet ),
					"controls" => 'yes' == $settings['arrows'] && 'yes' != $settings['arrows_tablet'] ? true : false,
					"nav"      => 'yes' == $settings['dots'] && 'yes' != $settings['dots_tablet'] ? true : false,
				),
				1024 => array(
					"items"    => intval( $col_desktop ),
					"controls" => 'yes' == $settings['arrows'] ? true : false,
					"nav"      => 'yes' == $settings['dots'] ? true : false,
				),
            ),
        );

        $tiny_slider_data = "data-tiny-slider='" . json_encode( $options ) . "'";

        return $tiny_slider_data;
    }
}
