<?php

namespace Elementor;

class goto_lightbox_video extends Widget_Base {

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_name() {
        return 'video-popup';
    }

    public function get_title() {
        return esc_html__( 'Video Popup', 'goto' );
    }

    public function get_icon() {
        return 'eicon-play';
    }

    public function get_script_depends() {
        return array( 'jquery-lity' );
    }

    public function get_style_depends() {
        return array( 'lity' );
    }

    protected function register_controls() {

        $this->start_controls_section( 'section_content', array(
            'label' => esc_html__( 'Content', 'goto' ),
        ));

        $this->add_control( 'widget_image', array(
            'label'     =>  esc_html__( 'Video thumbnail', 'goto' ),
            'type'      =>  Controls_Manager::MEDIA,
            'default'   =>  array(
                'url'   =>  Utils::get_placeholder_image_src()
            ),
        ));

        $this->add_control( 'video_url', array(
            'label'         =>  esc_html__( 'Video url', 'goto' ),
            'type'          =>  Controls_Manager::TEXT,
            'default'       =>  'https://vimeo.com/6942359',
            'description'   =>  esc_html__( 'Example: https://vimeo.com/6942359 or https://www.youtube.com/watch?v=k5Qw7At1PKc', 'goto' )
        ));

        $this->add_control( 'icon_play', array(
            'label'         =>  esc_html__( 'Icon play', 'goto' ),
            'type'          =>  Controls_Manager::ICON,
            'default'       =>  'fa fa-youtube-play',
            'include' => array(
                'fa fa-play',
                'fa fa-play-circle',
                'fa fa-play-circle-o',
                'fa fa-youtube-play',
                'fa fa-step-forward',
                'fa fa-fast-forward',
                'fa fa-forward',
                'fa fa-backward',
                'fa fa-fast-backward',
                'fa fa-step-backward',
            )
        ));

        $this->add_control( 'icon_color', array(
            'label'     =>  esc_html__( 'Icon color', 'goto' ),
            'type'      =>  Controls_Manager::COLOR,
            'default'   =>  '#ffffff',
            'selectors' => array(
                '{{WRAPPER}} .element-video-popup-icon' => 'color: {{VALUE}};'
            )
        ));

        $this->add_control( 'icon_hover_color', array(
            'label'     =>  esc_html__( 'Icon hover color', 'goto' ),
            'type'      =>  Controls_Manager::COLOR,
            'default'   =>  '#333333',
            'selectors' => array(
                '{{WRAPPER}} .element-video-popup-icon:hover' => 'color: {{VALUE}};'
            )
        ));

        $this->add_control( 'icon_size', array(
            'label'   =>  esc_html__( 'Icon size', 'goto' ),
            'type'    =>  Controls_Manager::SLIDER,
            'default' =>  array(
                'size' => 50
            ),
            'range' => array(
                'px' => array(
                    'min'  => 1,
                    'max'  => 500,
                    'step' => 1
                ),
            ),
            'size_units' => array( 'px' ),
            'selectors'  => array(
                '{{WRAPPER}} .element-video-popup-icon' => 'font-size: {{SIZE}}{{UNIT}};'
            )
        ));

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $img = $settings['widget_image'];
        $img_src = $img['url'];
        $img_alt = goto_img_alt( $img['id'], esc_attr__( 'Lightbox video image', 'goto' ) );
        ?>

        <div class="element-video-popup">
            <img src="<?php echo esc_url( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
            <a class="element-video-popup-icon <?php echo esc_attr( $settings['icon_play'] ); ?>" href="<?php echo esc_url( $settings['video_url'] ); ?>" data-lity></a>
        </div>
    <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new goto_lightbox_video() );