<?php if ( ! defined( 'FW' ) ) die( 'Forbidden' );

/**
 * Output a review in the HTML5 format.
 *
 * @var object $comment Comment to display.
 * @var int $depth Depth of comment.
 * @var array $args An array of arguments.
 * @var bool $has_children
 * @var int $stars_number
 * @var int $rate
 */

$tag = ( 'div' === $args['style'] ) ? 'div' : 'li';

?>


<<?php echo esc_attr( $tag ); ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( $has_children ? 'parent' : '' ); ?>>
    <article id="div-comment-<?php comment_ID(); ?>" class="comment-body" <?php goto_schema_markup( 'comment' ); ?>>
        <div class="comment-author vcard">
            <?php
                if ( 0 != $args['avatar_size'] ) {
                    echo get_avatar( $comment, 60 );
                }
            ?>
        </div>
    	<footer class="comment-meta">
    		<div class="comment-metadata">
                <strong class="fn" <?php goto_schema_markup( 'comment_author' ); ?>><?php echo get_comment_author_link(); ?></strong>
                <?php if( ! empty( $rate ) ): /*rating*/ ?>
                    <div class="rating">
                        <?php
                            for ( $i = 1; $i <= 5; $i ++ ) {
                                $voted = ( $i <= round( $rate ) ) ? ' voted' : '';
                                echo '<span class="fa fa-star' . $voted . '" data-vote="' . $i . '"></span>';
                            }
                        ?>
                    </div>
                <?php endif; ?>
    			<a class="fw-comment-time" href="<?php echo esc_url( get_comment_link( $comment->comment_ID, $args ) ); ?>" >
    				<time datetime="<?php comment_time( 'c' ); ?>"><?php echo get_comment_date(); ?></time>
    			</a>
    			<?php edit_comment_link( esc_html__( 'Edit', 'goto' ), '<span class="edit-link">', '</span>' ); ?>
    		</div>

    		<?php if ( '0' == $comment->comment_approved ): ?>
    			<p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'goto' ); ?></p>
    		<?php endif; ?>

            <div class="comment-content" <?php goto_schema_markup( 'comment_text' ); ?>>
                <?php comment_text(); ?>
            </div>
    	</footer>
    </article>