<?php
/**
 * The header for our theme.
 *
 * @package goto
 */

?>
<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head <?php goto_schema_markup( 'head' ); ?>>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="theme-container">
	<?php if (  function_exists( 'boostify_header_active' ) && boostify_header_active() ): ?>
		<?php boostify_get_header_template(); //Custom header ?>
	<?php else: ?>
	    <div id="theme-menu-layout">
			<?php goto_header(); ?>
		</div>
	<?php endif; ?>
	<div id="theme-page-header">
		<?php goto_page_header(); ?>
	</div>
	<?php goto_dialog_search_form(); ?>

<?php
goto_preloader();
