<?php
// @codingStandardsIgnoreStart
if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );



/* THEME SETUP
***************************************************/
add_action( 'after_setup_theme', 'goto_action_theme_setup' );
if ( ! function_exists( 'goto_action_theme_setup' ) ):
	function goto_action_theme_setup() {
		load_theme_textdomain( 'goto', get_template_directory() . '/languages' );
        add_theme_support( 'boostify-header-footer' );

		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'title-tag' );
        add_theme_support( 'custom-logo', array(
            'height'      => 84,
            'width'       => 24,
            'flex-width'  => true,
            'flex-height' => true,
        ) );

		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'audio',
			'quote',
			'link',
			'gallery',
		) );

        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption'
        ) );

		add_filter( 'use_default_gallery_style', '__return_false' );
	}
endif;


/* BODY CLASSES
***************************************************/
add_filter( 'body_class', 'goto_body_classes' );
function goto_body_classes( $classes ) {
    $id = get_queried_object_id();

    /*! GET CURRENT THEME VERSION
    ------------------------------------------------->*/
    $classes[] = 'goto-' . wp_get_theme()->Version;

    /* THEME START
    ------------------------------------------------->*/
    if( ! class_exists( 'Kirki' ) ){
        $classes[] = 'no-kirki-customize';
    }

    /*! BLOG CLASS
    ------------------------------------------------->*/
    if( goto_blog() ){
        $classes[] = 'group-blog';
    }

    /*! SINGLE TOUR STYLE
    ------------------------------------------------->*/
    $classes[] = 'single-' . goto_tour_header();

    return $classes;
}


/* REGISTER WIDGET AREA
***************************************************/
add_action( 'widgets_init', 'goto_widgets_init' );
function goto_widgets_init() {
    /*! BLOG WIDGET
    ------------------------------------------------->*/
	register_sidebar( array(
        'name'          => esc_html__( 'Blog Widget Area', 'goto' ),
        'id'            => 'blog-widget',
        'description'   => esc_html__( 'Appears in the blog sidebar section of the site.', 'goto'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h6 class="widget-title">',
        'after_title'   => '</h6>',
    ));

    /*! FOOTER WIDGET
    ------------------------------------------------->*/
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Widget Area', 'goto' ),
        'id'            => 'footer-widget',
        'description'   => esc_html__( 'Appears in the footer section of the site.', 'goto'),
        'before_widget' => '<aside id="%1$s" class="widget footer-widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h6 class="widget-title">',
        'after_title'   => '</h6>',
    ));

    /*! WOOCOMMERCE WIDGET
    ------------------------------------------------->*/
    if( class_exists( 'Woocommerce' ) ) {
        register_sidebar(array(
            'name'          => esc_html__('Shop Widget Area', 'goto'),
            'id'            => 'shop-widget',
            'description'   => esc_html__('Appears in the sidebar of shop page.', 'goto'),
            'before_widget' => '<aside id="%1$s" class="widget shop %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<h6 class="widget-title">',
            'after_title'   => '</h6>',
        ));
    }
}


/* ADD NEW ICON FOR ICON-V2 TYPE
***************************************************/
add_filter( 'fw:option_type:icon-v2:packs', 'goto_icon_v2' );
function goto_icon_v2( $default_packs ) {
    return array(
        'gotoicon' => array(
            'name'             => 'gotoicon',
            'title'            => esc_html__( 'Goto Icon', 'goto' ),
            'css_class_prefix' => 'goto-icon',
            'css_file'         => get_template_directory() . '/css/goto-icon.css',
            'css_file_uri'     => get_template_directory_uri() . '/css/goto-icon.css'
        )
    );
}


/* CUSTOM ADMIN STYLE
***************************************************/
add_action( 'admin_enqueue_scripts', 'goto_admin_style' );
function goto_admin_style() {
    wp_enqueue_style(
        'goto-admin-style',
        get_template_directory_uri() . '/css/custom.css'
    );
}


/* ADD CUSTOM STYLESHEET FOR VISUAL EDITOR OF SINGLE TOUR
***************************************************/
add_action( 'admin_init', 'goto_custom_css_for_single_ht_tour' );
function goto_custom_css_for_single_ht_tour(){
    global $pagenow;

    if ( 'post.php' === $pagenow && isset( $_GET['post'] ) && 'ht_tour' === get_post_type( $_GET['post'] ) )
        add_editor_style( 'css/editor-style-ht-tour.css' );
}


/* TOUR SINGLE CUSTOM SCRIPT
***************************************************/
add_action( 'fw_admin_enqueue_scripts:post', 'goto_single_tour_script' );
function goto_single_tour_script( WP_Post $post ){
    if ( 'ht_tour' == $post->post_type ) {
        wp_enqueue_script( 'goto-tour-custom-js' );
    }
}


/* LIVE PREVIEW FOR CUSTOMIZE
***************************************************/
add_action( 'customize_preview_init', 'goto_customizer_live_preview' );
function goto_customizer_live_preview(){
    wp_enqueue_script(
        'goto-customize-preview-js',
        get_template_directory_uri() . '/js/customize-preview.js',
        array(),
        null,
        true
    );
}


/* KIRKI: COMPILES INLINE CSS TO THEME STYLESHEET
***************************************************/
function goto_stylesheet_filter( $stylesheet ) {
    return 'goto-theme-style';
}
add_filter( 'kirki_goto_stylesheet', 'goto_stylesheet_filter', 99 );


/* ADD SETTING URL FOR TOUR POST TYPE
***************************************************/
add_action( 'admin_menu', 'goto_add_setting_tour' );
function goto_add_setting_tour() {
    global $submenu;

    $url = admin_url() . 'admin.php?page=fw-extensions&sub-page=extension&extension=tour';
    $submenu['edit.php?post_type=ht_tour'][] = array( esc_html__( 'Settings', 'goto' ), 'manage_options', $url );
}


/* ADD INLINE STYLESHEET
***************************************************/
if( ! function_exists( 'goto_add_custom_style' ) ):
    function goto_add_custom_style( $handle = '', $data = '' ) {
        if( empty( $handle ) || empty( $data )  ) return;

        wp_register_style( $handle, false );
        wp_enqueue_style( $handle );

        wp_add_inline_style( $handle, $data );
    }
endif;


/* INSTALL DEMO CONTENT
***************************************************/
add_filter( 'fw:ext:backups-demo:demos', 'goto_backups_demos' );
function goto_backups_demos( $demos ) {
    $demos_array = array(
        'goto' => array(
            'title'        => esc_html__( 'Goto Demo Full', 'goto' ),
            'screenshot'   => get_template_directory_uri() . '/screenshot.png',
            'preview_link' => '//boostifythemes.com/demo/wp/goto/',
        )
    );

    $download_url = 'https://boostifythemes.com/ht-demos/';

    foreach ( $demos_array as $id => $data ) {
        $demo = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
            'url'     => $download_url,
            'file_id' => $id,
        ));
        $demo->set_title( $data['title'] );
        $demo->set_screenshot( $data['screenshot'] );
        $demo->set_preview_link( $data['preview_link'] );

        $demos[ $demo->get_id() ] = $demo;

        unset( $demo );
    }

    return $demos;
}



/* ADD A CUSTOM COLUMN IN POSTS AND CUSTOM POST TYPES ADMIN SCREEN
***************************************************/

/*GET FEATURED IMAGE*/
function goto_get_featured_image( $post_ID ) {
    $img_id = get_post_thumbnail_id( $post_ID );
    if ( $img_id ) {
        $img_src = wp_get_attachment_image_src( $img_id, 'thumbnail' );
        return $img_src[0];
    }
}

/*ADD NEW COLUMN | `post` AND `ht_tour`*/
add_filter( 'manage_post_posts_columns', 'goto_columns_head', 10 );
add_filter( 'manage_ht_tour_posts_columns', 'goto_columns_head', 10 );
add_filter( 'manage_ht_dest_posts_columns', 'goto_columns_head', 10 );
function goto_columns_head( $defaults ) {
    $order = array();
    /* `cb` = checkbox*/
    $checkbox = 'cb';
    foreach( $defaults as $key => $value ) {
        $order[$key] = $value;
        if ( $key == $checkbox ){
            $order['thumbnail_image'] = esc_attr__( 'Image', 'goto' );
        }
    }
    return $order;
}

/*SHOW THE FEATURED IMAGE | `post` AND `ht_tour`*/
add_action( 'manage_post_posts_custom_column', 'goto_columns_content', 10, 2 );
add_action( 'manage_ht_tour_posts_custom_column', 'goto_columns_content', 10, 2 );
add_action( 'manage_ht_dest_posts_custom_column', 'goto_columns_content', 10, 2 );
function goto_columns_content( $column_name, $post_ID ) {
    if ( 'thumbnail_image' == $column_name ) {
        $_img_src = goto_get_featured_image( $post_ID );
        if ( $_img_src ) {
        ?>
            <a href="<?php echo get_edit_post_link( $post_ID ); ?>">
                <img src="<?php echo esc_url( $_img_src ); ?>" />
            </a>
        <?php }else{ ?>
            <a href="<?php echo get_edit_post_link( $post_ID ); ?>">
                <img src="<?php echo get_template_directory_uri() . '/images/thumbnail-default.jpg'; ?>" />
            </a>
        <?php
        }
    }
}

function goto_ajax_booking_tour() {
	global $woocommerce;
	check_ajax_referer( 'tour_booking_nonce' );

	$request_data = $_REQUEST['data'];
	$tour_data    = array();

	foreach ( $request_data as $data ) {
		$tour_data[$data['name']] = $data['value'];
	}

	// Check if the tour product already exists
	$product = get_page_by_title( $tour_data['booking-title'], 'OBJECT', 'product' );
	if ( $product ) {
		$product_id = $product->ID;
        update_post_meta( $product_id, '_price', $tour_data['booking-price'] );
        update_post_meta( $product_id, '_regular_price', $tour_data['booking-price'] );
        if ( ! empty( $tour_data['booking-sale-price'] )  ) {
            update_post_meta( $product_id, '_sale_price', $tour_data['booking-sale-price'] );
            update_post_meta( $product_id, '_price', $tour_data['booking-sale-price'] );
        }

	} else {
		// Create a woocommerce tour product
		$product_id = wp_insert_post( array(
			'post_title' 		=> $tour_data['booking-title'],
			'post_content' 		=> esc_html__('This is a variable product used for booking processed with WooCommerce.', 'goto'),
			'post_status' 		=> 'publish',
			'post_type' 		=> 'product',
			'comment_status' 	=> 'closed'
		) );

		// Set product thumbnail
		if ( has_post_thumbnail( $tour_data['booking-id'] ) ) {
			$thumbnail_id = get_post_thumbnail_id( $tour_data['booking-id'] );
			set_post_thumbnail( $product_id, $thumbnail_id );
		}

		$visibility_ids = wc_get_product_visibility_term_ids();
		if ( isset( $visibility_ids['exclude-from-catalog'] ) && isset( $visibility_ids['exclude-from-search'] ) ) {
			$product_visibility = array( $visibility_ids['exclude-from-catalog'], $visibility_ids['exclude-from-search'] );
		}

		// Hide this product in front end
		wp_set_object_terms( $product_id, $product_visibility, 'product_visibility' );

		// Set the product type
		wp_set_object_terms( $product_id, 'simple', 'product_type' );

		// Set the product price
		update_post_meta( $product_id, '_price', $tour_data['booking-price'] );
		update_post_meta( $product_id, '_regular_price', $tour_data['booking-price'] );
		if ( ! empty( $tour_data['booking-sale-price'] )  ) {
			update_post_meta( $product_id, '_sale_price', $tour_data['booking-sale-price'] );
            update_post_meta( $product_id, '__price', $tour_data['booking-sale-price'] );
		}
	}

	$cart_item_key = $woocommerce->cart->add_to_cart( $product_id );
	$woocommerce->cart->set_quantity( $cart_item_key, $tour_data['booking-quantity'], true );
    $woocommerce->session->set( 'booking_date', $tour_data['booking-date']);

	// Set new cookie if user hasn't logged in
	if ( ! is_user_logged_in() ) {
		$woocommerce->session->set_customer_session_cookie(true);
	}

	$response = array();

	$response['type']         = 'success';
	$response['redirect_url'] = get_permalink( wc_get_page_id( 'cart' ) );

	$response = wp_json_encode( $response );//$response

	die($response);
}
add_action( 'wp_ajax_goto_ajax_booking_tour', 'goto_ajax_booking_tour' );
add_action( 'wp_ajax_nopriv_goto_ajax_booking_tour', 'goto_ajax_booking_tour' );

add_action( 'woocommerce_add_order_item_meta', 'goto_hook_new_order_item_meta', 10, 3);
function goto_hook_new_order_item_meta($item_id, $values, $cart_item_key) {
   $session_var  = 'booking_date';
   $session_data = WC()->session->get($session_var);
   if(!empty($session_data)){
      wc_add_order_item_meta($item_id, $session_var, $session_data);
   }
   else{
      error_log("no session data", 0);
   }
}