<?php



	get_header();



	$id        = get_queried_object_id();

	$style     = goto_tour_header();

	$gallery   = fw_get_db_post_option( $id, 'gallery' );

	$video_url = fw_get_db_post_option( $id, 'video_url' );



	if ( ! empty( $video_url ) ) :

		wp_enqueue_style( 'lity' );

		wp_enqueue_script( 'jquery-lity' );

	endif;

	

	/*itinerary*/

	$pdf       = fw_get_db_post_option( $id, 'pdf' );

	$detail    = fw_get_db_post_option( $id, 'detail' );



	if ( ! $detail  ) {

		$detail    = fw_get_db_post_option( $id, 'ht_detail' );

	}



	if ( ! $pdf  ) {

		$pdf    = fw_get_db_post_option( $id, 'ht_pdf' );

	}

	/*price*/
	$price        = fw_get_db_post_option( $tour_id, 'price' );
	$sale_price   = fw_get_db_post_option( $tour_id, 'sale_price' );

	$sale         = ! empty( $price ) && is_numeric( $sale_price ) ? round( ( ( $price - $sale_price ) / $price ) * 100, 1 ) : 0;



	/*map*/

	$map       = fw_get_db_post_option( $id, 'tour_map' );

	$rating    = function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ? fw_ext_feedback_stars_get_post_rating( $id ) : array( 'count' => 0 );

	$gallery      = fw_get_db_post_option( $tour_id, 'gallery' );

	// Sticky sidebar.

	wp_enqueue_script( 'sticky-sidebar-js' );

	// Tour single.

	wp_enqueue_script( 'goto-tour-single' );

	$args = array(
		'pdf' => $pdf,
		'detail' => $detail,
		'map' => $map,
		'gallery' => $gallery,

	);

?>



<main id="main">

	

	<?php

		switch( $style ):

			case 'tour-1':

				/*PARALLAX*/

				$parallax        = get_theme_mod( 'c_parallax', true );

				$parallax_speed  = get_theme_mod( 'c_parallax_speed', true );

				$parallax_output = '';



				if( true == $parallax ){

					$parallax_output = 'id="page-header-parallax" data-speed="' . absint( $parallax_speed ) . '"';

				}

				?>



				<?php /*TOUR COVER IMAGE*/ ?>

				<div class="tour-cover-image" <?php echo wp_kses_post( $parallax_output ); ?>>

					<div class="container">

						<?php /*GALLERY LIGHBOX*/ ?>

						<?php if( ! empty( $gallery ) ): ?>

							<button class="tour-lightbox-btn" id="goto-view-photos"><?php esc_html_e( 'View Photos', 'goto' ); ?></button>



							<?php

								wp_enqueue_style( 'pswp-lightbox' );

								wp_enqueue_script( 'jquery-photoswipe' );

								wp_enqueue_script( 'jquery-pswp-ui' );



								$img_attr = '';

								foreach( $gallery as $k => $v ){

									$img     = wp_get_attachment_image_src( $v['attachment_id'], 'full' );

									$img_alt = goto_img_alt( $v['attachment_id'], esc_attr__( 'Image gallery', 'goto' ) );



									$img_attr .= '{';

									$img_attr .= "src: '{$img[0]}',";

									$img_attr .= "w: {$img[1]},";

									$img_attr .= "h: {$img[2]},";

									$img_attr .= "title: '{$img_alt}',";

									$img_attr .= '},';

								}



								wp_add_inline_script(

									'jquery-pswp-ui',

									"document.addEventListener( 'DOMContentLoaded', function () {

										var openPhotoSwipe = function() {

											var items,

												options,

												gallery,

												pswpElement = document.getElementsByClassName( 'goto-view-photo-content' )[0];



											items = [{$img_attr}];



											options = {

												history: true,

												focus: false,

												showAnimationDuration: 0,

												hideAnimationDuration: 0

											};

											

											gallery = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options );

											gallery.init();

										};

										document.getElementById( 'goto-view-photos' ).onclick = openPhotoSwipe;

									});",

									'after'

								);

							?>

							

							<?php /*START PHOTOSWIPE MARKUP*/ ?>

							<div class="pswp goto-view-photo-content">

								<div class="pswp__bg"></div>



								<div class="pswp__scroll-wrap">

									<div class="pswp__container">

										<div class="pswp__item"></div>

										<div class="pswp__item"></div>

										<div class="pswp__item"></div>

									</div>



									<div class="pswp__ui pswp__ui--hidden">

										<div class="pswp__top-bar">

											<div class="pswp__counter"></div>



											<button class="pswp__button pswp__button--close" title="<?php esc_attr_e( 'Close (Esc)', 'goto' ); ?>"></button>

											<button class="pswp__button pswp__button--share" title="<?php esc_attr_e( 'Share', 'goto' ); ?>"></button>

											<button class="pswp__button pswp__button--fs" title="<?php esc_attr_e( 'Toggle fullscreen', 'goto' ); ?>"></button>

											<button class="pswp__button pswp__button--zoom" title="<?php esc_attr_e( 'Zoom in/out', 'goto' ); ?>"></button>



											<div class="pswp__preloader">

												<div class="pswp__preloader__icn">

													<div class="pswp__preloader__cut">

														<div class="pswp__preloader__donut"></div>

													</div>

												</div>

											</div>

										</div>



										<div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">

											<div class="pswp__share-tooltip"></div> 

										</div>



										<button class="pswp__button pswp__button--arrow--left" title="<?php esc_attr_e( 'Previous (arrow left)', 'goto' ); ?>"></button>

										<button class="pswp__button pswp__button--arrow--right" title="<?php esc_attr_e( 'Next (arrow right)', 'goto' ); ?>"></button>



										<div class="pswp__caption">

											<div class="pswp__caption__center"></div>

										</div>

									</div>

								</div>

							</div>

							<?php /*END PHOTOSWIPE MARKUP*/ ?>

						<?php endif; ?>



						<?php /*VIDEO LIGHTBOX*/ ?>

						<?php if( ! empty( $video_url ) ):  ?>

							<a class="tour-lightbox-btn goto-video-preview" href="<?php echo esc_url( $video_url ); ?>" data-lity><?php esc_html_e( 'Video Preview', 'goto' ); ?></a>

						<?php endif; ?>

					</div>

				</div>

				

				<?php /*TOUR NAVIGATION*/ ?>

				<div class="fake-navbox">

					<div class="tour-navbox" id="tour-nav">

						<div class="container">

							<div class="tour-title-box">

								<h1 class="tour-title"><?php echo get_the_title( $id ); ?></h1>

								<?php if( 0 != $rating['count'] ){ ?>

									<div class="tour-under-title">

										<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>

										<span class="tour-review-count">

											<?php

												printf(

													_nx(

														'1 review',

														'%s review(s)',

														number_format_i18n( $rating['count'] ),

														'review count',

														'goto'

													),

													number_format_i18n( $rating['count'] )

												);

											?>

										</span>

									</div>

								<?php } ?>

							</div>

							<span class="tour-nav">

								<a href="#tour-link-info" class="tour-nav-item"><?php esc_html_e( 'Main Infomation', 'goto' ); ?></a>

								

								<?php if( ! empty( $pdf ) || ! empty( $detail ) ): ?>

									<a href="#tour-link-itinerary" class="tour-nav-item"><?php esc_html_e( 'Itinerary', 'goto' ); ?></a>

								<?php endif; ?>



								<?php if( ! empty( $map ) ): ?>

									<a href="#tour-link-map" class="tour-nav-item"><?php esc_html_e( 'Map', 'goto' ); ?></a>

								<?php endif; ?>



								<?php if ( defined( 'FW' ) && function_exists( 'fw_ext_feedback' ) ) { ?>

									<a href="#tour-link-reviews" class="tour-nav-item"><?php esc_html_e( 'Reviews', 'goto' ); ?></a>

								<?php } ?>

							</span>

						</div>

					</div>

				</div>



				<?php

				break;

			case 'tour-2':

				/*TOUR TITLE*/

				?>

				<div class="tour-title-box">

					<div class="container">

						<h1 class="tour-title"><?php echo get_the_title( $id ); ?></h1>

						<?php if( 0 != $rating['count'] ){ ?>

							<div class="tour-under-title">

								<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>

								<span class="tour-review-count">

									<?php

										printf(

											_nx(

												'1 review',

												'%s review(s)',

												number_format_i18n( $rating['count'] ),

												'review count',

												'goto'

											),

											number_format_i18n( $rating['count'] )

										);

									?>

								</span>

							</div>

						<?php } ?>

					</div>

				</div>



				<?php /*TOUR NAVIGATION*/ ?>

				<div class="fake-navbox">

					<div class="tour-navbox" id="tour-nav">

						<div class="container">

							<span class="tour-nav">

								<a href="#tour-link-info" class="tour-nav-item"><?php esc_html_e( 'Main Infomation', 'goto' ); ?></a>

								<?php if( ! empty( $pdf ) || ! empty( $detail ) ): ?>

									<a href="#tour-link-itinerary" class="tour-nav-item"><?php esc_html_e( 'Itinerary', 'goto' ); ?></a>

								<?php endif; ?>

								<?php if( ! empty( $map ) ): ?>

									<a href="#tour-link-map" class="tour-nav-item"><?php esc_html_e( 'Map', 'goto' ); ?></a>

								<?php endif; ?>

								<?php if ( comments_open() && defined( 'FW' ) && function_exists( 'fw_ext_feedback' ) ): ?>

									<a href="#tour-link-reviews" class="tour-nav-item"><?php esc_html_e( 'Reviews', 'goto' ); ?></a>

								<?php endif ?>

							</span>



							<?php /*VIDEO LIGHTBOX*/ ?>

							<?php if( ! empty( $video_url ) ):  ?>

								<a class="tour-lightbox-btn goto-video-preview" href="<?php echo esc_url( $video_url ); ?>" data-lity><?php esc_html_e( 'Video Preview', 'goto' ); ?></a>

							<?php endif; ?>

						</div>

					</div>

				</div>



				<?php

				break;

			case 'tour-3':

				/*GALLERY*/

				if( ! empty( $gallery ) ):

					/*LITY VIDEO LIGHTBOX*/

					wp_enqueue_style( 'tiny-slider' );

					wp_enqueue_script( 'tiny-slider-js' );

					wp_add_inline_script(

						'tiny-slider-js',

						"document.addEventListener( 'DOMContentLoaded', function(){

							var slider = tns({

								container: '#tour-3-slider',

								loop: false,

								items: 3,

								gutter: 1,

								mouseDrag: true,

								nav: true,

								arrowKeys: true,

								autoHeight: true,

								controls: false,

								responsive: {

									240: {

										items: 1

									},

									768: {

										items: 2,

										controls: true,

										nav: false

									},

									992: {

										items: 3,

										controls: true

									}

								}

							});

						} );",

						'after'

					);



					/*PHOTO SWIPE LIGHTBOX*/

					wp_enqueue_style( 'pswp-lightbox' );

					wp_enqueue_script( 'jquery-pswp-global' );

					wp_add_inline_script(

						'jquery-pswp-global',

						"window.addEventListener( 'load', function(){

							jQuery( '#tour-3-slider' ).photoSwipe( '.tour-3-slide-item', {

								bgOpacity: 0.9,

								shareEl: false

							});

						} );",

						'after'

					);

				?>

					<div class="tour-3-gallery">

						<div id="tour-3-slider">

							<?php

								foreach( $gallery as $key ):

									$img_src   = wp_get_attachment_image_url( $key['attachment_id'], 'full' );

									$img_large = wp_get_attachment_image_url( $key['attachment_id'], 'large' );

									$img_alt   = goto_img_alt( $key['attachment_id'], esc_attr__( 'Tour gallery image', 'goto' ) );

								?>

								<a href="<?php echo esc_url( $img_src ); ?>" class="tour-3-slide-item">

									<img src="<?php echo esc_url( $img_large ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">

								</a>

							<?php endforeach; ?>

						</div>



						<div class="container">

							<?php /*VIDEO LIGHTBOX*/ ?>

							<?php if( ! empty( $video_url ) ):  ?>

								<a class="tour-lightbox-btn goto-video-preview" href="<?php echo esc_url( $video_url ); ?>" data-lity><?php esc_html_e( 'Video Preview', 'goto' ); ?></a>

							<?php endif; ?>

						</div>

					</div>

				<?php endif; ?>



				<?php /*TOUR TITLE*/ ?>

				<div class="container">

					<div class="tour-title-box">

						<h1 class="tour-title"><?php echo get_the_title( $id ); ?></h1>

						<?php if( 0 != $rating['count'] ){ ?>

							<div class="tour-under-title">

								<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>

								<span class="tour-review-count">

									<?php

										printf(

											_nx(

												'1 review',

												'%s review(s)',

												number_format_i18n( $rating['count'] ),

												'review count',

												'goto'

											),

											number_format_i18n( $rating['count'] )

										);

									?>

								</span>

							</div>

						<?php } ?>

					</div>

				</div>



				<?php /*TOUR NAVIGATION*/ ?>

				<div class="fake-navbox">

					<div class="tour-navbox" id="tour-nav">

						<div class="container">

							<span class="tour-nav">

								<a href="#tour-link-info" class="tour-nav-item"><?php esc_html_e( 'Main Infomation', 'goto' ); ?></a>

								<?php if( ! empty( $pdf ) || ! empty( $detail ) ): ?>

									<a href="#tour-link-itinerary" class="tour-nav-item"><?php esc_html_e( 'Itinerary', 'goto' ); ?></a>

								<?php endif; ?>

								<?php if( ! empty( $map ) ): ?>

									<a href="#tour-link-map" class="tour-nav-item"><?php esc_html_e( 'Map', 'goto' ); ?></a>

								<?php endif; ?>

								<?php if ( comments_open() && defined( 'FW' ) && function_exists( 'fw_ext_feedback' ) ): ?>

									<a href="#tour-link-reviews" class="tour-nav-item"><?php esc_html_e( 'Reviews', 'goto' ); ?></a>

								<?php endif ?>



							</span>

						</div>

					</div>

				</div>

			<?php

				break;

		endswitch;



		while ( have_posts() ):

			the_post();

			get_template_part( 'template-parts/content', 'tour', $args );

		endwhile;



		/*EDIT LOCATION*/

		goto_edit_location( 'single_tour' );

	?>

</main>



<?php

$tour_vars = array(

	'url'   => admin_url( 'admin-ajax.php' ),

	'nonce' => wp_create_nonce( 'tour_booking_nonce' ),

);



if ( class_exists( 'WooCommerce' ) ) {

	$tour_vars['redirect_url'] = wc_get_cart_url();

}



wp_enqueue_script( 'goto-tour-booking' );

wp_localize_script(

	'goto-tour-booking',

	'tour_vars',

	$tour_vars

);

get_footer();